/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.graph;

import com.kipti.bnb.content.cogwheel_chain.graph.ChainInteractionFailedException;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChainPathfinder;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelNode;
import com.kipti.bnb.registry.BnbBlocks;
import com.kipti.bnb.registry.BnbConfigs;
import com.mojang.serialization.Codec;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PlacingCogwheelChain {
    public static final Codec<PlacingCogwheelChain> CODEC = PlacingCogwheelNode.CODEC.listOf().xmap(PlacingCogwheelChain::new, chain -> chain.visitedNodes);
    public static final StreamCodec<RegistryFriendlyByteBuf, PlacingCogwheelChain> STREAM_CODEC = StreamCodec.composite((StreamCodec)CatnipStreamCodecBuilders.list(PlacingCogwheelNode.STREAM_CODEC), chain -> chain.visitedNodes, PlacingCogwheelChain::new);
    public static final Integer MAX_CHAIN_BOUNDS = 32;
    private List<PlacingCogwheelNode> visitedNodes;

    public PlacingCogwheelChain(BlockPos startPos, Direction.Axis startAxis, boolean isLarge, boolean hasSmallCogwheelOffset) {
        this.visitedNodes = new ArrayList<PlacingCogwheelNode>(List.of(new PlacingCogwheelNode(startPos, startAxis, isLarge, hasSmallCogwheelOffset)));
    }

    public PlacingCogwheelChain(List<PlacingCogwheelNode> nodes) {
        this.visitedNodes = new ArrayList<PlacingCogwheelNode>(nodes);
    }

    public int getChainsRequiredInLoop() {
        return this.getChainsRequired(Vec3.atLowerCornerOf((Vec3i)this.visitedNodes.getLast().pos().subtract((Vec3i)this.visitedNodes.getFirst().pos())).length());
    }

    public int getChainsRequired(double length) {
        float factor = BnbConfigs.server().COGWHEEL_CHAIN_DRIVE_COST_FACTOR.getF();
        if (factor == 0.0f) {
            return 0;
        }
        for (int i = 0; i < this.visitedNodes.size() - 1; ++i) {
            BlockPos offset = this.visitedNodes.get(i + 1).pos().subtract((Vec3i)this.visitedNodes.get(i).pos());
            length += Vec3.atLowerCornerOf((Vec3i)offset).length();
        }
        return PlacingCogwheelChain.getChainsRequiredForLength(length);
    }

    public static int getChainsRequiredForLength(double length) {
        float factor = BnbConfigs.server().COGWHEEL_CHAIN_DRIVE_COST_FACTOR.getF();
        if (factor == 0.0f) {
            return 0;
        }
        return (int)Math.max(Math.round((double)factor * length / 5.0), 1L);
    }

    public static boolean isValidBlockTarget(BlockState state) {
        return state.is((Holder)AllBlocks.COGWHEEL) || state.is((Holder)AllBlocks.LARGE_COGWHEEL) || state.is(BnbBlocks.SMALL_EMPTY_FLANGED_COGWHEEL) || state.is(BnbBlocks.LARGE_EMPTY_FLANGED_COGWHEEL);
    }

    public static boolean isLargeBlockTarget(BlockState state) {
        return state.is((Holder)AllBlocks.LARGE_COGWHEEL) || state.is(BnbBlocks.LARGE_EMPTY_FLANGED_COGWHEEL);
    }

    public static boolean hasSmallCogwheelOffset(BlockState state) {
        return state.is((Holder)AllBlocks.COGWHEEL);
    }

    public boolean tryAddNode(BlockPos newPos, BlockState newBlockState) throws ChainInteractionFailedException {
        boolean isValidCandidate;
        boolean isWithinBounds;
        boolean hasSmallCogwheelOffset;
        boolean isLarge;
        PlacingCogwheelNode lastNode = this.getLastNode();
        if (!PlacingCogwheelChain.isValidBlockTarget(newBlockState)) {
            return false;
        }
        for (int i = 1; i < this.visitedNodes.size(); ++i) {
            if (!this.visitedNodes.get(i).pos().equals((Object)newPos)) continue;
            throw new ChainInteractionFailedException("cannot_revisit_node");
        }
        Direction.Axis axis = (Direction.Axis)newBlockState.getValue((Property)CogWheelBlock.AXIS);
        PlacingCogwheelNode newNode = new PlacingCogwheelNode(newPos, axis, isLarge = PlacingCogwheelChain.isLargeBlockTarget(newBlockState), hasSmallCogwheelOffset = PlacingCogwheelChain.hasSmallCogwheelOffset(newBlockState));
        boolean bl = isWithinBounds = !this.exceedsMaxBounds(newNode);
        if (!isWithinBounds) {
            throw new ChainInteractionFailedException("out_of_bounds");
        }
        int differenceOnAxis = Math.abs(newPos.get(axis) - lastNode.pos().get(axis));
        PlacingCogwheelNode lastLastNode = this.getSize() >= 2 ? this.visitedNodes.get(this.visitedNodes.size() - 2) : null;
        boolean isFlat = differenceOnAxis == 0;
        boolean isSameAxis = axis == lastNode.rotationAxis();
        double totalRadius = (isLarge ? 1.0 : 0.5) + (lastNode.isLarge() ? 1.0 : 0.5);
        boolean isAdjacent = isFlat && newPos.distSqr((Vec3i)lastNode.pos()) <= totalRadius * totalRadius;
        boolean isValidFlat = isSameAxis && isFlat && !isAdjacent;
        boolean isValidAxisChange = this.isValidLargeCogAxisConnection(lastNode, newPos, axis, isLarge);
        boolean bl2 = isValidCandidate = isValidFlat || isValidAxisChange;
        if (!isValidCandidate) {
            if (isAdjacent) {
                throw new ChainInteractionFailedException("cogwheels_cannot_touch");
            }
            if (!isSameAxis) {
                throw new ChainInteractionFailedException("not_valid_axis_change");
            }
            throw new ChainInteractionFailedException("not_flat_connection");
        }
        List<Integer> backwardsConnections = CogwheelChainPathfinder.getValidPathSteps(lastNode, newNode);
        if (backwardsConnections.isEmpty()) {
            throw new ChainInteractionFailedException("no_cogwheel_connection");
        }
        if (lastLastNode != null) {
            boolean hasPathBack = false;
            for (Integer side : backwardsConnections) {
                hasPathBack = hasPathBack || CogwheelChainPathfinder.isValidPathStep(lastLastNode, 1, lastNode, side) || CogwheelChainPathfinder.isValidPathStep(lastLastNode, -1, lastNode, side);
            }
            if (!hasPathBack) {
                throw new ChainInteractionFailedException("no_path_to_cogwheel");
            }
        }
        this.visitedNodes.add(newNode);
        return true;
    }

    private boolean isValidLargeCogAxisConnection(PlacingCogwheelNode lastNode, BlockPos newPos, Direction.Axis axis, boolean isLarge) {
        if (!lastNode.isLarge() || !isLarge) {
            return false;
        }
        BlockPos diff = newPos.subtract((Vec3i)lastNode.pos());
        int safeAxisOrdinal = 7 & ~(1 << axis.ordinal()) & ~(1 << lastNode.rotationAxis().ordinal());
        int[] component = new int[]{diff.getX(), diff.getY(), diff.getZ()};
        for (int i = 0; i < 3; ++i) {
            if (!(1 << i == safeAxisOrdinal ? Math.abs(component[i]) < 1 : Math.abs(component[i]) != 1)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlacingCogwheelChain that = (PlacingCogwheelChain)o;
        return Objects.equals(this.visitedNodes, that.visitedNodes);
    }

    public int hashCode() {
        return Objects.hashCode(this.visitedNodes);
    }

    public boolean canBuildChainIfLooping() throws ChainInteractionFailedException {
        if (this.getSize() < 2) {
            return false;
        }
        PlacingCogwheelNode firstNode = this.visitedNodes.getFirst();
        PlacingCogwheelNode lastNode = this.getLastNode();
        if (!firstNode.pos().equals((Object)lastNode.pos())) {
            return false;
        }
        this.visitedNodes.removeLast();
        if (CogwheelChainPathfinder.buildChainPath(this) == null) {
            throw new ChainInteractionFailedException("pathfinding_failed");
        }
        return true;
    }

    public List<PlacingCogwheelNode> getNodes() {
        return this.visitedNodes;
    }

    public PlacingCogwheelNode getNodeLooped(int i) {
        return this.visitedNodes.get((this.visitedNodes.size() + i % this.visitedNodes.size()) % this.visitedNodes.size());
    }

    public PlacingCogwheelNode getFirstNode() {
        return this.visitedNodes.getFirst();
    }

    public PlacingCogwheelNode getLastNode() {
        return this.visitedNodes.getLast();
    }

    public Vec3 getNodeCenter(int i) {
        return this.visitedNodes.get(i).pos().getCenter();
    }

    public int getSize() {
        return this.visitedNodes.size();
    }

    public int maxBounds() {
        return this.getMaxBoundsOfNodes(this.visitedNodes);
    }

    public boolean exceedsMaxBounds(PlacingCogwheelNode candidate) {
        ArrayList<PlacingCogwheelNode> nodesWithCandidate = new ArrayList<PlacingCogwheelNode>(this.visitedNodes);
        nodesWithCandidate.add(candidate);
        int newMaxBounds = this.getMaxBoundsOfNodes(nodesWithCandidate);
        return newMaxBounds > MAX_CHAIN_BOUNDS;
    }

    private int getMaxBoundsOfNodes(List<PlacingCogwheelNode> nodes) {
        Vec3i min = new Vec3i(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        Vec3i max = new Vec3i(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (PlacingCogwheelNode node : nodes) {
            BlockPos pos = node.pos();
            min = new Vec3i(Math.min(min.getX(), pos.getX()), Math.min(min.getY(), pos.getY()), Math.min(min.getZ(), pos.getZ()));
            max = new Vec3i(Math.max(max.getX(), pos.getX()), Math.max(max.getY(), pos.getY()), Math.max(max.getZ(), pos.getZ()));
        }
        return Math.max(Math.max(max.getX() - min.getX(), max.getY() - min.getY()), max.getZ() - min.getZ());
    }

    public boolean checkMatchingNodesInLevel(Level level) {
        for (PlacingCogwheelNode node : this.visitedNodes) {
            BlockState state = level.getBlockState(node.pos());
            if (!PlacingCogwheelChain.isValidBlockTarget(state)) {
                return false;
            }
            Direction.Axis axis = (Direction.Axis)state.getValue((Property)CogWheelBlock.AXIS);
            boolean isLarge = PlacingCogwheelChain.isLargeBlockTarget(state);
            boolean hasSmallCogwheelOffset = PlacingCogwheelChain.hasSmallCogwheelOffset(state);
            if (axis == node.rotationAxis() && isLarge == node.isLarge() && hasSmallCogwheelOffset == node.hasOffsetForSmallCogwheel()) continue;
            return false;
        }
        return true;
    }

    public PlacingCogwheelChain toLocalSpaceChain() {
        BlockPos origin = this.getFirstNode().pos();
        ArrayList<PlacingCogwheelNode> localNodes = new ArrayList<PlacingCogwheelNode>();
        for (PlacingCogwheelNode node : this.visitedNodes) {
            BlockPos localPos = node.pos().subtract((Vec3i)origin);
            localNodes.add(new PlacingCogwheelNode(localPos, node.rotationAxis(), node.isLarge(), node.hasOffsetForSmallCogwheel()));
        }
        return new PlacingCogwheelChain(localNodes);
    }

    public List<PlacingCogwheelNode> getVisitedNodes() {
        return this.visitedNodes;
    }

    public void setVisitedNodes(List<PlacingCogwheelNode> visitedNodes) {
        this.visitedNodes = visitedNodes;
    }
}

