/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.graph;

import com.kipti.bnb.content.cogwheel_chain.graph.PathedCogwheelNode;
import com.kipti.bnb.content.cogwheel_chain.graph.RenderedChainPathNode;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CogwheelChainGeometryBuilder {
    public static List<RenderedChainPathNode> buildFullChainFromPathNodes(List<PathedCogwheelNode> pathNodes) {
        PathedCogwheelNode nextNode;
        PathedCogwheelNode currentNode;
        PathedCogwheelNode previousNode;
        int i;
        ArrayList<RenderedChainPathNode> resultNodes = new ArrayList<RenderedChainPathNode>();
        ArrayList<Pair<Vec3, Vec3>> offsetsAtNodes = new ArrayList<Pair<Vec3, Vec3>>();
        int n = pathNodes.size();
        for (i = 0; i < n; ++i) {
            previousNode = pathNodes.get((n + i - 1) % n);
            currentNode = pathNodes.get(i);
            nextNode = pathNodes.get((i + 1) % n);
            Pair<Vec3, Vec3> inOutPositionsAtThisNode = CogwheelChainGeometryBuilder.calculateOffsets(previousNode, currentNode, nextNode);
            offsetsAtNodes.add(inOutPositionsAtThisNode);
        }
        for (i = 0; i < n; ++i) {
            previousNode = pathNodes.get((n + i - 1) % n);
            currentNode = pathNodes.get(i);
            nextNode = pathNodes.get((i + 1) % n);
            Pair previousOffsets = (Pair)offsetsAtNodes.get((i - 1 + n) % n);
            Pair currentOffsets = (Pair)offsetsAtNodes.get(i);
            Pair nextOffsets = (Pair)offsetsAtNodes.get((i + 1) % n);
            resultNodes.add(new RenderedChainPathNode(currentNode.localPos(), (Vec3)currentOffsets.getFirst()));
            resultNodes.addAll(CogwheelChainGeometryBuilder.wrappedArcBetweenPoints(currentNode, ((Vec3)previousOffsets.getSecond()).add(previousNode.center()), ((Vec3)currentOffsets.getFirst()).add(currentNode.center()), ((Vec3)currentOffsets.getSecond()).add(currentNode.center()), ((Vec3)nextOffsets.getFirst()).add(nextNode.center())));
            resultNodes.add(new RenderedChainPathNode(currentNode.localPos(), (Vec3)currentOffsets.getSecond()));
        }
        return resultNodes;
    }

    private static List<RenderedChainPathNode> wrappedArcBetweenPoints(PathedCogwheelNode currentNode, Vec3 outPreviousPositionWorld, Vec3 inCurrentOffsetWorld, Vec3 outCurrentOffsetWorld, Vec3 inNextPositionWorld) {
        Vec3 center = currentNode.localPos().getCenter();
        Vec3 prevLocal = outPreviousPositionWorld.subtract(center);
        Vec3 startLocal = inCurrentOffsetWorld.subtract(center);
        Vec3 endLocal = outCurrentOffsetWorld.subtract(center);
        Vec3 nextLocal = inNextPositionWorld.subtract(center);
        double r = startLocal.length();
        if (r <= 1.0E-9) {
            return List.of();
        }
        Vec3 inDirection = startLocal.subtract(prevLocal);
        if (inDirection.length() < 1.0E-9) {
            inDirection = nextLocal.subtract(startLocal);
        }
        inDirection = inDirection.normalize();
        Vec3 outDirection = endLocal.subtract(nextLocal);
        if (outDirection.length() < 1.0E-9) {
            outDirection = prevLocal.subtract(endLocal);
        }
        outDirection = outDirection.normalize();
        Vec3 axis = CogwheelChainGeometryBuilder.getDirectionOfAxis(currentNode).normalize();
        if (axis == null) {
            throw new IllegalStateException("axis null for chainNode " + String.valueOf(currentNode));
        }
        Vec3 u = startLocal.normalize();
        Vec3 w = endLocal.normalize();
        double crossDot = axis.dot(u.cross(w));
        double dot = Math.max(-1.0, Math.min(1.0, u.dot(w)));
        double signedAngle = Math.atan2(crossDot, dot);
        Vec3 tangentAtStart = axis.cross(startLocal);
        double tangentLen = tangentAtStart.length();
        double tangentDot = 0.0;
        if (tangentLen > 1.0E-9) {
            tangentAtStart = tangentAtStart.scale(1.0 / tangentLen);
            tangentDot = inDirection.dot(tangentAtStart);
        } else {
            tangentDot = inDirection.dot(u) > 0.0 ? 1.0 : -1.0;
        }
        double EPS = 1.0E-9;
        if (Math.abs(tangentDot) > 1.0E-9) {
            double desiredSign;
            double angleSign = Math.signum(signedAngle);
            double d = desiredSign = tangentDot > 0.0 ? 1.0 : -1.0;
            if (angleSign == 0.0) {
                signedAngle = dot > 0.999999 ? 0.0 : desiredSign * Math.PI;
            } else if (angleSign != desiredSign) {
                signedAngle -= Math.signum(signedAngle) * 2.0 * Math.PI;
            }
        }
        double absAngle = Math.abs(signedAngle);
        double approxArcLength = r * absAngle;
        int segments = Math.max(1, (int)(Math.ceil(approxArcLength) * 3.0));
        ArrayList<RenderedChainPathNode> result = new ArrayList<RenderedChainPathNode>();
        for (int i = 1; i < segments; ++i) {
            double t = (double)i / (double)segments;
            double theta = signedAngle * t;
            Vec3 rotatedLocal = CogwheelChainGeometryBuilder.rotateAroundAxis(startLocal, axis, theta);
            result.add(new RenderedChainPathNode(currentNode.localPos(), rotatedLocal));
        }
        return result;
    }

    private static Vec3 rotateAroundAxis(Vec3 v, Vec3 axis, double angle) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        return v.scale(cos).add(axis.cross(v).scale(sin)).add(axis.scale(axis.dot(v) * (1.0 - cos)));
    }

    private static int getLooped(int[] concavities, int i) {
        return concavities[(i + concavities.length) % concavities.length];
    }

    public static Pair<Vec3, Vec3> calculateOffsets(PathedCogwheelNode previousNode, PathedCogwheelNode currentNode, PathedCogwheelNode nextNode) {
        Vec3 incomingPointOnCircle = CogwheelChainGeometryBuilder.getTangentPointOnCircle(previousNode, currentNode, true);
        Vec3 outgoingPointOnCircle = CogwheelChainGeometryBuilder.getTangentPointOnCircle(nextNode, currentNode, false);
        return Pair.of((Object)incomingPointOnCircle, (Object)outgoingPointOnCircle);
    }

    @NotNull
    private static Vec3 getDirectionOfAxis(PathedCogwheelNode currentNode) {
        return Vec3.atLowerCornerOf((Vec3i)Direction.fromAxisAndDirection((Direction.Axis)currentNode.rotationAxis(), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).getNormal());
    }

    @NotNull
    private static Vec3 getConnectionDirection(PathedCogwheelNode previousNode, PathedCogwheelNode currentNode) {
        Vec3 incomingADiff = currentNode.center().subtract(previousNode.center());
        if (previousNode.rotationAxis() != currentNode.rotationAxis()) {
            Vec3 previousAxis = CogwheelChainGeometryBuilder.getDirectionOfAxis(previousNode);
            incomingADiff = incomingADiff.subtract(previousAxis.scale(incomingADiff.dot(previousAxis)));
        }
        Vec3 axis = CogwheelChainGeometryBuilder.getDirectionOfAxis(currentNode);
        return incomingADiff.subtract(axis.scale(axis.dot(incomingADiff)));
    }

    public static Vec3 getTangentPointOnCircle(PathedCogwheelNode previousNode, PathedCogwheelNode currentNode, boolean isIncoming) {
        double currentRadius;
        double previousRadius;
        Vec3 incoming;
        Vec3 axis = CogwheelChainGeometryBuilder.getDirectionOfAxis(currentNode);
        Vec3 vec3 = incoming = isIncoming ? CogwheelChainGeometryBuilder.getConnectionDirection(previousNode, currentNode) : CogwheelChainGeometryBuilder.getConnectionDirection(currentNode, previousNode);
        double d = previousNode.isLarge() ? 1.0 : (previousRadius = (double)(0.5f + (previousNode.offsetForSmallCogwheel() ? 0.125f : 0.0f)));
        double d2 = currentNode.isLarge() ? 1.0 : (currentRadius = (double)(0.5f + (currentNode.offsetForSmallCogwheel() ? 0.125f : 0.0f)));
        if (previousNode.rotationAxis() != currentNode.rotationAxis()) {
            return CogwheelChainGeometryBuilder.getDirectionOfAxis(previousNode).scale((double)previousNode.localPos().subtract((Vec3i)currentNode.localPos()).get(previousNode.rotationAxis()));
        }
        if (previousNode.side() == currentNode.side()) {
            return incoming.normalize().cross(axis).scale(-currentRadius * (double)currentNode.side());
        }
        double factor = previousRadius / (previousRadius + currentRadius);
        Vec3 tangentOrigin = incoming.scale(factor);
        double distance = (double)(isIncoming ? 1 : -1) * tangentOrigin.length();
        double sineRatio = previousRadius / distance;
        double cosRatio = Math.sqrt(1.0 - sineRatio * sineRatio);
        double perpendicularHeight = cosRatio * currentRadius;
        double lengthAlongIncoming = sineRatio * currentRadius;
        return incoming.normalize().cross(axis).scale(-perpendicularHeight * (double)currentNode.side()).add(incoming.normalize().scale(-lengthAlongIncoming));
    }
}

