/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.block;

import com.kipti.bnb.content.cogwheel_chain.block.CogwheelChainBlockEntity;
import com.kipti.bnb.registry.BnbBlockEntities;
import com.kipti.bnb.registry.BnbBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CogwheelChainBlock
extends RotatedPillarKineticBlock
implements IBE<CogwheelChainBlockEntity>,
SpecialBlockItemRequirement {
    private static final List<CogwheelChainBlock> ALL_CHAIN_BLOCKS = new ArrayList<CogwheelChainBlock>();
    private static final Lazy<Map<Block, CogwheelChainBlock>> DEFAULT_CHAIN_BLOCKS_BY_SOURCE = Lazy.of(() -> {
        HashMap<Block, CogwheelChainBlock> map = new HashMap<Block, CogwheelChainBlock>();
        for (CogwheelChainBlock chainBlock : ALL_CHAIN_BLOCKS) {
            BlockEntry<?> source = chainBlock.sourceBlock.get();
            map.put((Block)source.get(), chainBlock);
        }
        return map;
    });
    private final boolean isLarge;
    private final Supplier<BlockEntry<?>> sourceBlock;

    protected CogwheelChainBlock(boolean large, BlockBehaviour.Properties properties, Supplier<BlockEntry<?>> sourceBlock) {
        super(properties);
        this.isLarge = large;
        this.sourceBlock = sourceBlock;
        ALL_CHAIN_BLOCKS.add(this);
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        return this.sourceBlock.get().asStack();
    }

    @Nullable
    public static BlockState getChainState(BlockState existingState, boolean large, Direction.Axis axis) {
        Block chainBlock = (Block)((Map)DEFAULT_CHAIN_BLOCKS_BY_SOURCE.get()).get(existingState.getBlock());
        if (chainBlock == null) {
            return null;
        }
        return (BlockState)chainBlock.defaultBlockState().setValue((Property)AXIS, (Comparable)axis);
    }

    public boolean isLargeChainCog() {
        return this.isLarge;
    }

    public static CogwheelChainBlock smallFlanged(BlockBehaviour.Properties properties) {
        return new CogwheelChainBlock(false, properties, () -> BnbBlocks.SMALL_EMPTY_FLANGED_COGWHEEL);
    }

    public static CogwheelChainBlock largeFlanged(BlockBehaviour.Properties properties) {
        return new CogwheelChainBlock(true, properties, () -> BnbBlocks.LARGE_EMPTY_FLANGED_COGWHEEL);
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof CogwheelChainBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        CogwheelChainBlockEntity cogwheelChainBE = (CogwheelChainBlockEntity)be;
        ItemStack drops = cogwheelChainBE.destroyChain(player == null);
        if (player != null && !player.hasInfiniteMaterials()) {
            player.getInventory().placeItemBackInInventory(drops);
        }
        state.spawnAfterBreak(serverLevel, pos, ItemStack.EMPTY, true);
        context.getLevel().levelEvent(2001, context.getClickedPos(), Block.getId((BlockState)state));
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (this.isLarge ? AllShapes.LARGE_GEAR : AllShapes.SMALL_GEAR).get((Direction.Axis)state.getValue((Property)AXIS));
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader worldIn, @NotNull BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition((boolean)ICogWheel.isLargeCog((BlockState)state), (LevelReader)worldIn, (BlockPos)pos, (Direction.Axis)((Direction.Axis)state.getValue((Property)AXIS)));
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockEntity be;
        if (!level.isClientSide && player.hasInfiniteMaterials() && (be = level.getBlockEntity(pos)) instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity cogwheelChainBE = (CogwheelChainBlockEntity)be;
            cogwheelChainBE.clearStoredChains();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)world, (BlockPos)pos, (BlockState)newState);
    }

    public Class<CogwheelChainBlockEntity> getBlockEntityClass() {
        return CogwheelChainBlockEntity.class;
    }

    public BlockEntityType<? extends CogwheelChainBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BnbBlockEntities.COGWHEEL_CHAIN.get();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == state.getValue((Property)AXIS);
    }

    public final float getGeometryChainShift() {
        return BnbBlocks.SMALL_FLANGED_COGWHEEL_CHAIN.is((Object)this) ? 0.125f : 0.0f;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public ItemRequirement getRequiredItems(BlockState state, @Nullable BlockEntity be) {
        return ItemRequirement.of((BlockState)this.sourceBlock.get().getDefaultState(), (BlockEntity)be);
    }

    public BlockState getSourceBlockState() {
        return this.sourceBlock.get().getDefaultState();
    }
}

