/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.voiding;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeItem;

public class VoidUpgradeWrapper
extends UpgradeWrapperBase<VoidUpgradeWrapper, VoidUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IOverflowResponseUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToVoid = new HashSet<Integer>();
    private VoidType voidType;

    public VoidUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((VoidUpgradeItem)this.upgradeItem).getFilterSlotCount(), ModCoreDataComponents.FILTER_ATTRIBUTES);
        this.filterLogic.setAllowByDefault(true);
        this.setFromLegacyComponent();
        this.setVoidOverflowDefaultOrLoadFromNbt(VoidType.ALWAYS);
    }

    private void setFromLegacyComponent() {
        if (this.upgrade.has(ModCoreDataComponents.LEGACY_SHOULD_VOID_OVERFLOW)) {
            VoidType migratedVoidType = (Boolean)this.upgrade.get(ModCoreDataComponents.LEGACY_SHOULD_VOID_OVERFLOW) != false ? VoidType.SLOT_OVERFLOW : VoidType.ALWAYS;
            this.upgrade.remove(ModCoreDataComponents.LEGACY_SHOULD_VOID_OVERFLOW);
            this.setVoidType(migratedVoidType);
        }
    }

    @Override
    public ItemStack onBeforeInsert(InventoryHandler inventoryHandler, int slot, ItemStack stack, boolean simulate) {
        if (this.voidType == VoidType.SLOT_OVERFLOW && inventoryHandler.getStackInSlot(slot).isEmpty() && this.filterLogic.matchesFilter(stack)) {
            if (inventoryHandler.getSlotTracker().getFullStacks().contains(ItemStackKey.of(stack))) {
                return ItemStack.EMPTY;
            }
            return stack;
        }
        return this.voidType == VoidType.ALWAYS && this.filterLogic.matchesFilter(stack) ? ItemStack.EMPTY : stack;
    }

    @Override
    public ItemStack onBeforeInsert(InventoryHandler inventoryHandler, ItemStack stack, boolean simulate) {
        return this.voidType == VoidType.ALWAYS && this.filterLogic.matchesFilter(stack) ? ItemStack.EMPTY : stack;
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        this.upgrade.set(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)false);
    }

    public void setVoidType(VoidType voidType) {
        if (voidType == VoidType.ALWAYS && !((VoidUpgradeItem)this.upgradeItem).isVoidAlwaysEnabled()) {
            return;
        }
        this.voidType = voidType;
        this.upgrade.set(ModCoreDataComponents.VOID_TYPE, (Object)voidType);
        this.save();
    }

    public void setVoidOverflowDefaultOrLoadFromNbt(VoidType voidOverflowDefault) {
        VoidType vt = (VoidType)((Object)this.upgrade.getOrDefault(ModCoreDataComponents.VOID_TYPE, (Object)voidOverflowDefault));
        if (!((VoidUpgradeItem)this.upgradeItem).isVoidAlwaysEnabled() && vt == VoidType.ALWAYS) {
            vt = VoidType.SLOT_OVERFLOW;
        }
        this.voidType = vt;
    }

    public boolean shouldVoidOverflow() {
        return !((VoidUpgradeItem)this.upgradeItem).isVoidAlwaysEnabled() || this.voidType != VoidType.ALWAYS;
    }

    public VoidType getVoidType() {
        if (this.voidType == VoidType.ALWAYS && !((VoidUpgradeItem)this.upgradeItem).isVoidAlwaysEnabled()) {
            return VoidType.SLOT_OVERFLOW;
        }
        return this.voidType;
    }

    @Override
    public void onSlotChange(IItemHandler inventoryHandler, int slot) {
        if (!this.shouldWorkInGUI() || this.shouldVoidOverflow()) {
            return;
        }
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (this.filterLogic.matchesFilter(slotStack)) {
            this.slotsToVoid.add(slot);
        }
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (this.slotsToVoid.isEmpty()) {
            return;
        }
        InventoryHandler storageInventory = this.storageWrapper.getInventoryHandler();
        for (int slot : this.slotsToVoid) {
            storageInventory.extractItem(slot, storageInventory.getStackInSlot(slot).getCount(), false);
        }
        this.slotsToVoid.clear();
    }

    @Override
    public boolean worksInGui() {
        return this.shouldWorkInGUI();
    }

    @Override
    public ItemStack onSlotOverflow(ItemStack stack) {
        return this.voidType == VoidType.SLOT_OVERFLOW && this.filterLogic.matchesFilter(stack) ? ItemStack.EMPTY : stack;
    }

    @Override
    public ItemStack onStorageOverflow(ItemStack stack) {
        return this.voidType == VoidType.STORAGE_OVERFLOW && this.filterLogic.matchesFilter(stack) ? ItemStack.EMPTY : stack;
    }

    @Override
    public boolean stackMatchesFilter(ItemStack stack) {
        return this.filterLogic.matchesFilter(stack);
    }

    public boolean isVoidAlwaysEnabled() {
        return ((VoidUpgradeItem)this.upgradeItem).isVoidAlwaysEnabled();
    }
}

