/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.voiding;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class VoidUpgradeContainer
extends UpgradeContainerBase<VoidUpgradeWrapper, VoidUpgradeContainer> {
    private static final String DATA_SHOULD_WORKD_IN_GUI = "shouldWorkdInGUI";
    private static final String DATA_VOID_TYPE = "voidType";
    private final FilterLogicContainer<FilterLogic> filterLogicContainer = new FilterLogicContainer<FilterLogic>(((VoidUpgradeWrapper)this.upgradeWrapper)::getFilterLogic, this, this.slots::add);

    public VoidUpgradeContainer(Player player, int containerId, VoidUpgradeWrapper wrapper, UpgradeContainerType<VoidUpgradeWrapper, VoidUpgradeContainer> type) {
        super(player, containerId, wrapper, type);
    }

    @Override
    public void handlePacket(CompoundTag data) {
        if (data.contains(DATA_SHOULD_WORKD_IN_GUI)) {
            this.setShouldWorkdInGUI(data.getBoolean(DATA_SHOULD_WORKD_IN_GUI));
        } else if (data.contains(DATA_VOID_TYPE)) {
            this.setVoidType(VoidType.fromName(data.getString(DATA_VOID_TYPE)));
        }
        this.filterLogicContainer.handlePacket(data);
    }

    public FilterLogicContainer<FilterLogic> getFilterLogicContainer() {
        return this.filterLogicContainer;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        ((VoidUpgradeWrapper)this.upgradeWrapper).setShouldWorkdInGUI(shouldWorkdInGUI);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), DATA_SHOULD_WORKD_IN_GUI, shouldWorkdInGUI));
    }

    public void setVoidType(VoidType voidType) {
        ((VoidUpgradeWrapper)this.upgradeWrapper).setVoidType(voidType);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundTag(), DATA_VOID_TYPE, voidType));
    }

    public boolean shouldWorkInGUI() {
        return ((VoidUpgradeWrapper)this.upgradeWrapper).shouldWorkInGUI();
    }

    public VoidType getVoidType() {
        return ((VoidUpgradeWrapper)this.upgradeWrapper).getVoidType();
    }
}

