/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.common.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoReplacedEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ReplacedSnowGolem
implements GeoReplacedEntity {
    protected static final RawAnimation WALK = RawAnimation.begin().thenLoop("walk");
    protected static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    protected static final RawAnimation SIT = RawAnimation.begin().thenLoop("sit");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    private static <P extends GeoAnimatable> PlayState predicate(AnimationState<P> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(WALK);
        } else {
            Entity entity = (Entity)event.getData(DataTickets.ENTITY);
            if (entity.isPassenger() && entity.getVehicle() != null) {
                event.getController().setAnimation(SIT);
            } else {
                event.getController().setAnimation(IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 20, ReplacedSnowGolem::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public EntityType<?> getReplacingEntityType() {
        return EntityType.SNOW_GOLEM;
    }
}

