/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.mixin;

import com.github.eterdelta.crittersandcompanions.item.PearlNecklaceItem;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import java.util.function.Predicate;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NearestAttackableTargetGoal.class})
public abstract class NearestAttackableTargetGoalMixin<T extends LivingEntity>
extends TargetGoal {
    @Accessor
    abstract TargetingConditions getTargetConditions();

    protected NearestAttackableTargetGoalMixin(Mob mob, boolean mustSee) {
        super(mob, mustSee);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>(Lnet/minecraft/world/entity/Mob;Ljava/lang/Class;IZZLjava/util/function/Predicate;)V"})
    private void onInit(Mob mob, Class<T> targetType, int randomInterval, boolean mustSee, boolean mustReach, Predicate<LivingEntity> targetPredicate, CallbackInfo callback) {
        if (targetPredicate != null) {
            this.getTargetConditions().selector(targetPredicate.and(target -> PearlNecklaceItem.getWearing((Entity)target).map(PearlNecklaceItem::getLevel).map(level -> Services.CONFIGS.common().necklaceRangeDebuff((EntityType<?>)mob.getType(), (int)level)).filter(it -> it > 0.0).map(debuff -> this.getFollowDistance() - this.getFollowDistance() * debuff).map(range -> target.position().closerThan((Position)mob.position(), range.doubleValue())).orElse(true)));
        }
    }
}

