/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.item;

import com.github.eterdelta.crittersandcompanions.extension.ISilkLeashState;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundSilkLeashStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SilkLeashItem
extends Item {
    public SilkLeashItem(Item.Properties properties) {
        super(properties);
    }

    public static int updateLeashStates(LivingEntity leashOwner, LivingEntity leashedEntity) {
        Map<Entity, ISilkLeashState> updatedStates = SilkLeashItem.updateLeashStatesLocal(leashOwner, leashedEntity);
        if (!updatedStates.isEmpty()) {
            CACPacketHandler.SILK_LEASH_STATE.sendToTracking((Entity)(leashOwner == null ? leashedEntity : leashOwner), new ClientboundSilkLeashStatePacket(updatedStates.entrySet().stream().map(entry -> new ClientboundSilkLeashStatePacket.LeashData(((Entity)entry.getKey()).getId(), (IntList)new IntArrayList(((ISilkLeashState)entry.getValue()).getLeashingEntities().stream().mapToInt(Entity::getId).toArray()), (IntList)new IntArrayList(((ISilkLeashState)entry.getValue()).getLeashedByEntities().stream().mapToInt(Entity::getId).toArray()))).collect(Collectors.toList())));
        }
        return updatedStates.size();
    }

    public static Map<Entity, ISilkLeashState> updateLeashStatesLocal(LivingEntity leashOwner, LivingEntity leashedEntity) {
        if (leashOwner == null && leashedEntity == null) {
            throw new IllegalArgumentException("Both leash members cannot be null");
        }
        HashMap<Object, ISilkLeashState> modifiedEntities = new HashMap<Object, ISilkLeashState>();
        if (leashOwner == null) {
            ISilkLeashState leashedLeashState = (ISilkLeashState)leashedEntity;
            if (leashedLeashState.getLeashedByEntities().isEmpty()) {
                return Map.of();
            }
            for (Entity entity : leashedLeashState.getLeashedByEntities()) {
                if (!(entity instanceof ISilkLeashState)) continue;
                ISilkLeashState state = (ISilkLeashState)entity;
                state.getLeashingEntities().remove(leashedEntity);
                modifiedEntities.put(entity, state);
            }
            leashedLeashState.getLeashedByEntities().clear();
            modifiedEntities.put(leashedEntity, leashedLeashState);
        } else {
            ISilkLeashState ownerLeashState = (ISilkLeashState)leashOwner;
            if (leashedEntity == null) {
                if (ownerLeashState.getLeashingEntities().isEmpty()) {
                    return Map.of();
                }
                for (Entity entity : ownerLeashState.getLeashingEntities()) {
                    ISilkLeashState state = (ISilkLeashState)entity;
                    state.getLeashedByEntities().remove(leashOwner);
                    modifiedEntities.put(entity, state);
                }
                ownerLeashState.getLeashingEntities().clear();
            } else {
                if (!SilkLeashItem.canLeash((Entity)leashOwner, (Entity)leashedEntity)) {
                    return Map.of();
                }
                ISilkLeashState leashedEntityLeashState = (ISilkLeashState)leashedEntity;
                leashedEntityLeashState.getLeashedByEntities().add(leashOwner);
                ownerLeashState.getLeashingEntities().add(leashedEntity);
                modifiedEntities.put(leashedEntity, leashedEntityLeashState);
            }
            modifiedEntities.put(leashOwner, ownerLeashState);
        }
        return Map.copyOf(modifiedEntities);
    }

    private static boolean canLeash(Entity sourceEntity, Entity targetEntity) {
        if (!(sourceEntity instanceof ISilkLeashState)) {
            return false;
        }
        ISilkLeashState sourceLeashState = (ISilkLeashState)sourceEntity;
        if (sourceEntity == targetEntity) {
            return false;
        }
        return Stream.concat(sourceLeashState.getLeashingEntities().stream(), sourceLeashState.getLeashedByEntities().stream()).noneMatch(entity -> entity == targetEntity);
    }

    public InteractionResult interactLivingEntity(ItemStack handStack, Player player, LivingEntity entity, InteractionHand interactionHand) {
        ISilkLeashState playerLeashState = (ISilkLeashState)player;
        if (handStack.is((Item)CACItems.SILK_LEAD.get()) && playerLeashState.getLeashingEntities().isEmpty()) {
            if (!player.getAbilities().instabuild) {
                handStack.shrink(1);
            }
            if (!player.level().isClientSide()) {
                SilkLeashItem.updateLeashStates((LivingEntity)player, entity);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

