/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.extension.IBubbleState;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.network.ClientboundBubbleStatePacket;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import java.util.EnumSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DumboOctopusEntity
extends WaterAnimal
implements GeoEntity,
Bucketable {
    private static final EntityDataAccessor<Boolean> RESTING = SynchedEntityData.defineId(DumboOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(DumboOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(DumboOctopusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int restTimer;
    protected boolean bubblingPlayer;
    protected ServerPlayer bubbledPlayer;

    public DumboOctopusEntity(EntityType<? extends DumboOctopusEntity> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new DumboOctopusMoveControl(90, 90, 1.0f, 1.0f, false);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 180);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 14.0).add(Attributes.MOVEMENT_SPEED, 0.06);
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public boolean removeWhenFarAway(double distance) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RESTING, (Object)false);
        builder.define(VARIANT, (Object)0);
        builder.define(FROM_BUCKET, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BubblePlayerGoal());
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal(this, 1.0, 40));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Resting", this.isResting());
        compound.putInt("Variant", this.getVariant());
        compound.putBoolean("FromBucket", this.fromBucket());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setResting(compound.getBoolean("Resting"));
        this.setVariant(compound.getInt("Variant"));
        this.setFromBucket(compound.getBoolean("FromBucket"));
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean fromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)fromBucket);
    }

    public void saveToBucketTag(ItemStack bucketStack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)bucketStack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucketStack, nbt -> nbt.putInt("Variant", this.getVariant()));
    }

    public void loadFromBucketTag(CompoundTag bucketCompound) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)bucketCompound);
        this.setVariant(bucketCompound.getInt("Variant"));
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)CACItems.DUMBO_OCTOPUS_BUCKET.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_AXOLOTL;
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide() && !this.bubblingPlayer && this.isEffectiveAi()) {
            if (this.isInWater()) {
                if (this.isResting()) {
                    if (--this.restTimer <= 0) {
                        this.setResting(false);
                    }
                    this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.01, 0.0));
                } else if (this.random.nextFloat() <= 0.001f) {
                    this.restTimer = this.random.nextInt(200, 601);
                    this.setResting(true);
                }
            } else {
                this.setResting(false);
            }
        }
    }

    protected PathNavigation createNavigation(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public void travel(Vec3 speed) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), speed);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(speed);
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        return Bucketable.bucketMobPickup((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.mobInteract(player, interactionHand));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData) {
        if (mobSpawnType == MobSpawnType.BUCKET) {
            return spawnGroupData;
        }
        this.setVariant(this.random.nextInt(0, 4));
        return super.finalizeSpawn(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.isResting()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dumbo_octopus_idle"));
        } else if (this.isInWater()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dumbo_octopus_swim"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("dumbo_octopus_on_land"));
        }
        return PlayState.CONTINUE;
    }

    public void sendBubble(ServerPlayer player, boolean state) {
        if (!(player instanceof IBubbleState)) {
            return;
        }
        IBubbleState bubbleState = (IBubbleState)player;
        bubbleState.setBubbleActive(state);
        CACPacketHandler.BUBBLE_STATE.sendToTracking((Entity)player, new ClientboundBubbleStatePacket(state, player.getId()));
    }

    public ServerPlayer getBubbledPlayer() {
        return this.bubbledPlayer;
    }

    public boolean isResting() {
        return (Boolean)this.entityData.get(RESTING);
    }

    public void setResting(boolean resting) {
        this.entityData.set(RESTING, (Object)resting);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)Mth.clamp((int)variant, (int)0, (int)3));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 4, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    class DumboOctopusMoveControl
    extends SmoothSwimmingMoveControl {
        public DumboOctopusMoveControl(int maxTurnX, int maxTurnY, float inWaterSpeedModifier, float outsideWaterSpeedModifier, boolean applyGravity) {
            super((Mob)DumboOctopusEntity.this, maxTurnX, maxTurnY, inWaterSpeedModifier, outsideWaterSpeedModifier, applyGravity);
        }

        public void tick() {
            if (!DumboOctopusEntity.this.isResting()) {
                super.tick();
            }
        }
    }

    class BubblePlayerGoal
    extends Goal {
        private final Level level;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private boolean bubbleSent;

        public BubblePlayerGoal() {
            this.level = DumboOctopusEntity.this.level();
            this.navigation = DumboOctopusEntity.this.getNavigation();
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            ServerPlayer player = (ServerPlayer)this.level.getNearestPlayer((Entity)DumboOctopusEntity.this, 6.0);
            if (player != null && player.getAirSupply() < 150) {
                DumboOctopusEntity.this.bubbledPlayer = player;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return DumboOctopusEntity.this.bubbledPlayer != null && DumboOctopusEntity.this.bubbledPlayer.isAlive() && DumboOctopusEntity.this.bubbledPlayer.getAirSupply() <= 150;
        }

        public void start() {
            DumboOctopusEntity.this.bubblingPlayer = true;
            this.timeToRecalcPath = 0;
        }

        public void tick() {
            DumboOctopusEntity.this.getLookControl().setLookAt((Entity)DumboOctopusEntity.this.bubbledPlayer, 10.0f, (float)DumboOctopusEntity.this.getMaxHeadXRot());
            if (DumboOctopusEntity.this.distanceToSqr((Entity)DumboOctopusEntity.this.bubbledPlayer) > 2.0) {
                --this.timeToRecalcPath;
                if (this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = this.adjustedTickDelay(10);
                    if (!DumboOctopusEntity.this.isLeashed() && !DumboOctopusEntity.this.isPassenger()) {
                        this.navigation.moveTo((Entity)DumboOctopusEntity.this.bubbledPlayer, 2.0);
                    }
                }
            } else if (!this.bubbleSent) {
                DumboOctopusEntity.this.sendBubble(DumboOctopusEntity.this.bubbledPlayer, true);
                this.bubbleSent = true;
            }
            if (this.bubbleSent) {
                DumboOctopusEntity.this.bubbledPlayer.setAirSupply(150);
            }
        }

        public void stop() {
            DumboOctopusEntity.this.bubblingPlayer = false;
            DumboOctopusEntity.this.sendBubble(DumboOctopusEntity.this.bubbledPlayer, false);
            this.bubbleSent = false;
            DumboOctopusEntity.this.bubbledPlayer.playSound((SoundEvent)CACSounds.BUBBLE_POP.get());
            DumboOctopusEntity.this.bubbledPlayer = null;
            this.navigation.stop();
        }
    }

    static class RandomSwimmingGoal
    extends net.minecraft.world.entity.ai.goal.RandomSwimmingGoal {
        private final DumboOctopusEntity dumboOctopus;

        public RandomSwimmingGoal(DumboOctopusEntity dumboOctopus, double speedModifier, int interval) {
            super((PathfinderMob)dumboOctopus, speedModifier, interval);
            this.dumboOctopus = dumboOctopus;
        }

        public boolean canUse() {
            return !this.dumboOctopus.isResting() && super.canUse();
        }
    }
}

