/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions;

import com.github.eterdelta.crittersandcompanions.api.CACColors;
import com.github.eterdelta.crittersandcompanions.entity.DragonflyEntity;
import com.github.eterdelta.crittersandcompanions.entity.DumboOctopusEntity;
import com.github.eterdelta.crittersandcompanions.entity.FerretEntity;
import com.github.eterdelta.crittersandcompanions.entity.JumpingSpiderEntity;
import com.github.eterdelta.crittersandcompanions.entity.KoiFishEntity;
import com.github.eterdelta.crittersandcompanions.entity.LeafInsectEntity;
import com.github.eterdelta.crittersandcompanions.entity.OtterEntity;
import com.github.eterdelta.crittersandcompanions.entity.RedPandaEntity;
import com.github.eterdelta.crittersandcompanions.entity.SeaBunnyEntity;
import com.github.eterdelta.crittersandcompanions.entity.ShimaEnagaEntity;
import com.github.eterdelta.crittersandcompanions.handler.SpawnHandler;
import com.github.eterdelta.crittersandcompanions.network.CACPacketHandler;
import com.github.eterdelta.crittersandcompanions.platform.RegistryEntry;
import com.github.eterdelta.crittersandcompanions.platform.RegistryHelper;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import com.github.eterdelta.crittersandcompanions.registry.CACBlocks;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;

public class CrittersAndCompanions {
    public static final String MODID = "crittersandcompanions";
    private static final RegistryHelper<CreativeModeTab> CREATIVE_TABS = Services.PLATFORM.createRegistryHelper(Registries.CREATIVE_MODE_TAB, "crittersandcompanions");
    public static final RegistryEntry<CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("main", () -> CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).icon(() -> ((Item)CACItems.PEARL_NECKLACE_1.get()).getDefaultInstance()).title((Component)Component.translatable((String)"itemGroup.crittersandcompanions")).build());

    public static ResourceLocation createId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static void init() {
        CACBlocks.init();
        CACEntities.init();
        CACItems.init();
        CACSounds.init();
        CACPacketHandler.registerPackets();
        CrittersAndCompanions.registerColors();
    }

    public static void setup() {
        SpawnHandler.registerSpawnPlacements();
    }

    public static void onAttributeCreation(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier> event) {
        event.accept((EntityType<? extends LivingEntity>)((EntityType)CACEntities.OTTER.get()), OtterEntity.createAttributes().build());
        event.accept((EntityType<? extends LivingEntity>)((EntityType)CACEntities.JUMPING_SPIDER.get()), JumpingSpiderEntity.createAttributes().build());
        event.accept((EntityType<? extends LivingEntity>)((EntityType)CACEntities.KOI_FISH.get()), KoiFishEntity.createAttributes().build());
        event.accept((EntityType<? extends LivingEntity>)((EntityType)CACEntities.DRAGONFLY.get()), DragonflyEntity.createAttributes().build());
        event.accept((EntityType<? extends LivingEntity>)((EntityType)CACEntities.SEA_BUNNY.get()), SeaBunnyEntity.createAttributes().build());
        event.accept((EntityType<? extends LivingEntity>)((EntityType)CACEntities.SHIMA_ENAGA.get()), ShimaEnagaEntity.createAttributes().build());
        event.accept((EntityType<? extends LivingEntity>)((EntityType)CACEntities.FERRET.get()), FerretEntity.createAttributes().build());
        event.accept((EntityType<? extends LivingEntity>)((EntityType)CACEntities.DUMBO_OCTOPUS.get()), DumboOctopusEntity.createAttributes().build());
        event.accept((EntityType<? extends LivingEntity>)((EntityType)CACEntities.LEAF_INSECT.get()), LeafInsectEntity.createAttributes().build());
        event.accept((EntityType<? extends LivingEntity>)((EntityType)CACEntities.RED_PANDA.get()), RedPandaEntity.createAttributes().build());
    }

    private static void registerColors() {
        CACColors.register(DyeColor.WHITE);
        CACColors.register(DyeColor.ORANGE);
        CACColors.register(DyeColor.MAGENTA);
        CACColors.register(DyeColor.LIGHT_BLUE);
        CACColors.register(DyeColor.YELLOW);
        CACColors.register(DyeColor.LIME);
        CACColors.register(DyeColor.PINK);
        CACColors.register(DyeColor.GRAY);
        CACColors.register(DyeColor.LIGHT_GRAY);
        CACColors.register(DyeColor.CYAN);
        CACColors.register(DyeColor.PURPLE);
        CACColors.register(DyeColor.BLUE);
        CACColors.register(DyeColor.BROWN);
        CACColors.register(DyeColor.GREEN);
        CACColors.register(DyeColor.RED);
        CACColors.register(DyeColor.BLACK);
    }
}

