/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.phys.Vec3;

public class RibbitGoHomeGoal
extends Goal {
    private final RibbitEntity ribbit;
    private final float homePointRange;
    private final float speedModifier;
    private final int interval;

    public RibbitGoHomeGoal(RibbitEntity ribbit, float homePointRange, float speedModifier, int interval) {
        this.ribbit = ribbit;
        this.homePointRange = homePointRange;
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.ribbit.distanceToSqr(this.ribbit.getHomePosition().getX(), this.ribbit.getHomePosition().getY(), this.ribbit.getHomePosition().getZ()) <= (double)(this.homePointRange * this.homePointRange) && this.ribbit.getRandom().nextInt(RandomStrollGoal.reducedTickDelay((int)this.interval)) != 0) {
            return false;
        }
        return this.ribbit.level().isNight();
    }

    public boolean canContinueToUse() {
        return !this.ribbit.getNavigation().isDone() && !this.ribbit.isVehicle();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        super.tick();
        float waterModifier = this.ribbit.isInWater() ? 2.0f : 1.0f;
        this.ribbit.getNavigation().setSpeedModifier((double)(this.speedModifier * waterModifier));
    }

    public void start() {
        Vec3 distanceVariance = new Vec3((double)(this.ribbit.getRandom().nextFloat() * this.homePointRange * 2.0f - this.homePointRange), (double)(this.ribbit.getRandom().nextFloat() * this.homePointRange * 2.0f - this.homePointRange), (double)(this.ribbit.getRandom().nextFloat() * this.homePointRange * 2.0f - this.homePointRange));
        float waterModifier = this.ribbit.isInWater() ? 2.0f : 1.0f;
        this.ribbit.getNavigation().moveTo(distanceVariance.x() + (double)this.ribbit.getHomePosition().getX(), distanceVariance.y() + (double)this.ribbit.getHomePosition().getY(), distanceVariance.z() + (double)this.ribbit.getHomePosition().getZ(), (double)(this.speedModifier * waterModifier));
    }

    public void stop() {
        this.ribbit.getNavigation().stop();
    }
}

