/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.world.inventory.AlbumMenu;
import io.github.mortuusars.exposure.world.item.component.album.AlbumContent;
import io.github.mortuusars.exposure.world.item.component.album.AlbumPage;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumContent;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumPage;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class AlbumItem
extends Item {
    public AlbumItem(Item.Properties properties) {
        super(properties);
    }

    public AlbumContent getContent(ItemStack stack) {
        return (AlbumContent)stack.getOrDefault(Exposure.DataComponents.ALBUM_CONTENT, (Object)AlbumContent.EMPTY);
    }

    public void setContent(ItemStack stack, AlbumContent content) {
        stack.set(Exposure.DataComponents.ALBUM_CONTENT, (Object)content);
    }

    public void updatePage(ItemStack stack, int index, Function<Optional<AlbumPage>, AlbumPage> pageUpdater) {
        AlbumPage page = pageUpdater.apply(this.getContent(stack).getPage(index));
        this.setContent(stack, this.getContent(stack).toMutable().setPage(index, page).toImmutable());
    }

    public int getPhotographsCount(ItemStack stack) {
        return this.getContent(stack).pages().stream().filter(albumPage -> !albumPage.photograph().isEmpty()).toList().size();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int albumSlot = usedHand == InteractionHand.OFF_HAND ? 40 : player.getInventory().selected;
            this.open(serverPlayer, itemStack, albumSlot);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(blockPos);
        if (blockState.is(Blocks.LECTERN)) {
            return LecternBlock.tryPlaceBook((LivingEntity)context.getPlayer(), (Level)level, (BlockPos)blockPos, (BlockState)blockState, (ItemStack)context.getItemInHand()) ? InteractionResult.sidedSuccess((boolean)level.isClientSide) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void open(ServerPlayer player, final ItemStack albumStack, final int albumSlot) {
        MenuProvider menuProvider = new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return albumStack.getHoverName();
            }

            @NotNull
            public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                return new AlbumMenu(containerId, playerInventory, albumSlot);
            }
        };
        PlatformHelper.openMenu(player, menuProvider, buffer -> buffer.writeVarInt(albumSlot));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        int photographsCount;
        if (((Boolean)Config.Client.ALBUM_PHOTOS_COUNT_TOOLTIP.get()).booleanValue() && (photographsCount = this.getPhotographsCount(stack)) > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"item.exposure.album.tooltip.photos_count", (Object[])new Object[]{photographsCount}));
        }
    }

    public boolean shouldPlayEquipAnimation(ItemStack oldStack, ItemStack newStack) {
        return oldStack.getItem() != newStack.getItem();
    }

    public ItemStack sign(ItemStack albumStack, String title, String author) {
        ItemStack signedAlbumStack = new ItemStack((ItemLike)Exposure.Items.SIGNED_ALBUM.get());
        List<SignedAlbumPage> signedPages = this.getContent(albumStack).removeTrailingPages().pages().stream().map(AlbumPage::convertToSigned).toList();
        SignedAlbumContent signedAlbumContent = new SignedAlbumContent(title, author, signedPages);
        signedAlbumStack.set(Exposure.DataComponents.SIGNED_ALBUM_CONTENT, (Object)signedAlbumContent);
        return signedAlbumStack;
    }
}

