/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraItem;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public abstract class Camera {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final CameraHolder holder;
    protected final CameraId id;

    public Camera(CameraHolder holder, CameraId id) {
        this.holder = holder;
        this.id = id;
    }

    public abstract ItemStack getItemStack();

    public abstract Packet createSyncPacket();

    public CameraHolder getHolder() {
        return this.holder;
    }

    public CameraId getId() {
        return this.id;
    }

    public void update() {
    }

    public boolean isEmpty() {
        return !(this.getItemStack().getItem() instanceof CameraItem);
    }

    public boolean isActive() {
        return this.map(CameraItem::isActive, Boolean.valueOf(false));
    }

    public boolean inSelfieMode() {
        return this.map(CameraItem::isInSelfieMode).orElse(false);
    }

    public boolean idMatches(CameraId id) {
        return this.id.equals(id);
    }

    public boolean isShutterOpen() {
        return this.map((CameraItem item, ItemStack stack) -> item.getShutter().isOpen((ItemStack)stack), Boolean.valueOf(false));
    }

    public boolean deactivate() {
        CameraItem cameraItem;
        Item item;
        ItemStack stack = this.getItemStack();
        if (this.getId().matches(stack) && (item = stack.getItem()) instanceof CameraItem && (cameraItem = (CameraItem)item).isActive(stack)) {
            cameraItem.deactivate(this.getHolder().asHolderEntity(), stack);
            return true;
        }
        return false;
    }

    public void release() {
        this.ifPresent((item, stack) -> item.release(this.getHolder(), this.getItemStack()), () -> LOGGER.error("Cannot take a shot: camera is not active. Camera Holder: {}", (Object)this.holder));
    }

    public Camera ifPresent(BiConsumer<CameraItem, ItemStack> ifPresent) {
        ItemStack stack = this.getItemStack();
        Item item = stack.getItem();
        if (item instanceof CameraItem) {
            CameraItem item2 = (CameraItem)item;
            ifPresent.accept(item2, stack);
        }
        return this;
    }

    public Camera ifPresent(BiConsumer<CameraItem, ItemStack> ifPresent, Runnable orElse) {
        ItemStack stack = this.getItemStack();
        Item item = stack.getItem();
        if (item instanceof CameraItem) {
            CameraItem item2 = (CameraItem)item;
            ifPresent.accept(item2, stack);
        } else {
            orElse.run();
        }
        return this;
    }

    public <T> Optional<T> map(Function<ItemStack, T> map) {
        ItemStack stack = this.getItemStack();
        if (stack.getItem() instanceof CameraItem) {
            return Optional.ofNullable(map.apply(stack));
        }
        return Optional.empty();
    }

    public <T> T map(Function<ItemStack, T> map, T orElse) {
        ItemStack stack = this.getItemStack();
        if (stack.getItem() instanceof CameraItem) {
            return map.apply(stack);
        }
        return orElse;
    }

    public <T> Optional<T> map(BiFunction<CameraItem, ItemStack, T> map) {
        ItemStack stack = this.getItemStack();
        Item item = stack.getItem();
        if (item instanceof CameraItem) {
            CameraItem item2 = (CameraItem)item;
            return Optional.ofNullable(map.apply(item2, stack));
        }
        return Optional.empty();
    }

    public <T> T map(BiFunction<CameraItem, ItemStack, T> map, T orElse) {
        ItemStack stack = this.getItemStack();
        Item item = stack.getItem();
        if (item instanceof CameraItem) {
            CameraItem item2 = (CameraItem)item;
            return map.apply(item2, stack);
        }
        return orElse;
    }

    public <T extends Item, R> Optional<R> mapAttachment(Attachment<T> attachment, BiFunction<T, ItemStack, R> func) {
        if (this.getItemStack().getItem() instanceof CameraItem) {
            return attachment.map(this.getItemStack(), func);
        }
        return Optional.empty();
    }
}

