/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.serverbound;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.world.entity.CameraStandEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public record CameraStandTurnC2SP(int entityId, double yRot, double xRot) implements Packet
{
    public static final ResourceLocation ID = Exposure.resource("camera_stand_turn");
    public static final CustomPacketPayload.Type<CameraStandTurnC2SP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, CameraStandTurnC2SP> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, CameraStandTurnC2SP::entityId, (StreamCodec)ByteBufCodecs.DOUBLE, CameraStandTurnC2SP::yRot, (StreamCodec)ByteBufCodecs.DOUBLE, CameraStandTurnC2SP::xRot, CameraStandTurnC2SP::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow direction, Player player) {
        Entity entity = player.level().getEntity(this.entityId);
        if (!(entity instanceof CameraStandEntity)) {
            return false;
        }
        CameraStandEntity stand = (CameraStandEntity)entity;
        if (player.equals((Object)stand.operator()) || stand.getOwnerPlayer().map(pl -> pl.equals((Object)player)).orElse(false).booleanValue()) {
            stand.turn(this.yRot, this.xRot);
        }
        return true;
    }
}

