/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.serverbound;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.world.inventory.AlbumMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public record AlbumSyncNoteC2SP(int pageIndex, String text) implements Packet
{
    public static final ResourceLocation ID = Exposure.resource("album_update_note");
    public static final CustomPacketPayload.Type<AlbumSyncNoteC2SP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, AlbumSyncNoteC2SP> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, AlbumSyncNoteC2SP::pageIndex, (StreamCodec)ByteBufCodecs.STRING_UTF8, AlbumSyncNoteC2SP::text, AlbumSyncNoteC2SP::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow flow, Player player) {
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Cannot handle packet: Player was null");
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof AlbumMenu)) {
            throw new IllegalStateException("Player receiving this packet should have AlbumMenu open. Current menu: " + String.valueOf(player.containerMenu));
        }
        AlbumMenu albumMenu = (AlbumMenu)abstractContainerMenu;
        albumMenu.updatePage(this.pageIndex, page -> page.setNote(this.text));
        return true;
    }
}

