/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.core;

import com.aizistral.nochatreports.common.config.NCRConfig;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public enum SigningMode {
    DEFAULT,
    NEVER,
    ALWAYS,
    PROMPT,
    ON_DEMAND,
    NEVER_FORCED;


    public String getNameKey() {
        return "gui.nochatreports.signing_mode." + this.name().toLowerCase();
    }

    public MutableComponent getName() {
        if (this != DEFAULT) {
            return Component.translatable((String)this.getNameKey());
        }
        return Component.translatable((String)this.getNameKey(), (Object[])new Object[]{NCRConfig.getClient().defaultSigningMode().getName()});
    }

    public String getTooltipKey() {
        return "gui.nochatreports.signing_mode." + this.name().toLowerCase() + ".tooltip";
    }

    public MutableComponent getTooltip() {
        return Component.translatable((String)this.getTooltipKey());
    }

    public SigningMode next() {
        SigningMode result = null;
        result = this.ordinal() == SigningMode.values().length - 1 ? SigningMode.values()[0] : SigningMode.values()[this.ordinal() + 1];
        return result.isSelectable() ? result : result.next();
    }

    public SigningMode resolve() {
        return switch (this.ordinal()) {
            case 0 -> NCRConfig.getClient().defaultSigningMode();
            case 5 -> NEVER;
            default -> this;
        };
    }

    public boolean isSelectable() {
        return this != NEVER_FORCED;
    }

    public boolean isSelectableGlobally() {
        return this.isSelectable() && this != DEFAULT;
    }

    public static SigningMode nullable(@Nullable SigningMode mode) {
        return mode == null ? DEFAULT : mode;
    }
}

