/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.shaderpack;

import com.google.common.collect.ImmutableList;
import dev.djefrey.colorwheel.Colorwheel;
import dev.djefrey.colorwheel.engine.ClrwlBlendModeOverride;
import dev.djefrey.colorwheel.engine.ClrwlOitAccumulateOverride;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramGroup;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramId;
import dev.djefrey.colorwheel.util.Utils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.irisshaders.iris.gl.IrisRenderSystem;
import net.irisshaders.iris.gl.blending.BlendMode;
import net.irisshaders.iris.gl.blending.BlendModeFunction;
import net.irisshaders.iris.gl.blending.BufferBlendInformation;
import net.irisshaders.iris.gl.texture.InternalTextureFormat;
import net.irisshaders.iris.helpers.StringPair;
import net.irisshaders.iris.shaderpack.option.OrderBackedProperties;
import net.irisshaders.iris.shaderpack.option.ShaderPackOptions;
import net.irisshaders.iris.shaderpack.preprocessor.PropertiesPreprocessor;

public class ClrwlShaderProperties {
    private final Map<ClrwlProgramId, ClrwlBlendModeOverride> programBlendOverrides = new HashMap<ClrwlProgramId, ClrwlBlendModeOverride>();
    private final Map<ClrwlProgramId, ArrayList<BufferBlendInformation>> bufferBlendOverrides = new HashMap<ClrwlProgramId, ArrayList<BufferBlendInformation>>();
    private boolean shadowEnabled = true;
    private boolean gbuffersOitEnabled = false;
    private int[] gbuffersOitCoeffRanks = new int[0];
    private final List<ClrwlOitAccumulateOverride> gbuffersOitAccumulateOverrides = new ArrayList<ClrwlOitAccumulateOverride>();
    private boolean shadowOitEnabled = false;
    private int[] shadowOitCoeffRanks = new int[0];
    private final List<ClrwlOitAccumulateOverride> shadowOitAccumulateOverrides = new ArrayList<ClrwlOitAccumulateOverride>();

    public ClrwlShaderProperties() {
    }

    public ClrwlShaderProperties(String str, ShaderPackOptions options, Iterable<StringPair> environmentDefines) {
        String preprocessedStr = PropertiesPreprocessor.preprocessSource((String)str, (ShaderPackOptions)options, environmentDefines);
        OrderBackedProperties properties = new OrderBackedProperties();
        try {
            properties.load(new StringReader(preprocessedStr));
        }
        catch (IOException e) {
            Colorwheel.LOGGER.error("Could not load colorwheel.properties", (Throwable)e);
        }
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            InternalTextureFormat format;
            Optional<Object> coefficientId;
            String key = (String)property.getKey();
            String value = (String)property.getValue();
            String[] path = key.split("\\.");
            if (path.length == 0) continue;
            if (path[0].equals("shadow")) {
                if (path.length != 2 || !path[1].equals("enabled")) continue;
                this.shadowEnabled = value.equalsIgnoreCase("true");
                continue;
            }
            if (path[0].equals("blend")) {
                int id;
                ClrwlProgramId programId;
                block47: {
                    if (path.length == 2) {
                        Optional<ClrwlProgramId> maybeProgramId = ClrwlProgramId.fromName(path[1]);
                        if (maybeProgramId.isEmpty()) {
                            Colorwheel.LOGGER.warn("Unknown program: {}", (Object)path[1]);
                            continue;
                        }
                        programId = maybeProgramId.get();
                        if (value.equals("off")) {
                            this.programBlendOverrides.put(programId, new ClrwlBlendModeOverride(null));
                            continue;
                        }
                        this.parseBlendMode(value).ifPresent(bm -> this.programBlendOverrides.put(programId, new ClrwlBlendModeOverride((BlendMode)bm)));
                        continue;
                    }
                    if (path.length != 3) continue;
                    if (!IrisRenderSystem.supportsBufferBlending()) {
                        throw new RuntimeException("Buffer blending not supported");
                    }
                    Optional<ClrwlProgramId> maybeProgramId = ClrwlProgramId.fromName(path[1]);
                    if (maybeProgramId.isEmpty()) {
                        Colorwheel.LOGGER.warn("Unknown program: {}", (Object)path[1]);
                        continue;
                    }
                    programId = maybeProgramId.get();
                    String buffer = path[2];
                    if (programId.group() == ClrwlProgramGroup.SHADOW) {
                        if (!buffer.startsWith("shadowcolor")) {
                            Colorwheel.LOGGER.error("Attempt to disable blend on invalid buffer: {}", (Object)buffer);
                            continue;
                        }
                        try {
                            id = Integer.parseInt(buffer.substring("shadowcolor".length()));
                            break block47;
                        }
                        catch (NumberFormatException e) {
                            Colorwheel.LOGGER.error("Attempt to disable blend on invalid buffer: {}", (Object)buffer);
                            continue;
                        }
                    }
                    if (!buffer.startsWith("colortex")) {
                        Colorwheel.LOGGER.error("Attempt to disable blend on invalid buffer: {}", (Object)buffer);
                        continue;
                    }
                    try {
                        id = Integer.parseInt(buffer.substring("colortex".length()));
                    }
                    catch (NumberFormatException e) {
                        Colorwheel.LOGGER.error("Attempt to disable blend on invalid buffer: {}", (Object)buffer);
                        continue;
                    }
                }
                ArrayList list = this.bufferBlendOverrides.computeIfAbsent(programId, s -> new ArrayList());
                if (value.equals("off")) {
                    list.add(new BufferBlendInformation(id, null));
                    continue;
                }
                this.parseBlendMode(value).ifPresent(bm -> list.add(new BufferBlendInformation(id, bm)));
                continue;
            }
            if (!path[0].equals("oit")) continue;
            if (path.length == 1) {
                boolean on;
                this.gbuffersOitEnabled = on = value.trim().equalsIgnoreCase("true");
                this.shadowOitEnabled = on;
                continue;
            }
            if (path[1].equals("gbuffers")) {
                if (path.length == 2) {
                    this.gbuffersOitEnabled = value.trim().equalsIgnoreCase("true");
                    continue;
                }
                if (path[2].equals("coefficientRanks") && path.length == 3) {
                    this.parseCoefficientsRanks(value).ifPresent(ranks -> {
                        this.gbuffersOitCoeffRanks = ranks;
                    });
                    continue;
                }
                if (path[2].startsWith("colortex")) {
                    int drawBuffer;
                    try {
                        drawBuffer = Integer.parseUnsignedInt(path[2].substring(8));
                    }
                    catch (NumberFormatException e) {
                        Colorwheel.LOGGER.error("Invalid attachment: {}", (Object)path[2]);
                        continue;
                    }
                    if (path.length == 3) {
                        if (value.equals("frontmost")) {
                            coefficientId = Optional.empty();
                        } else {
                            try {
                                coefficientId = Optional.of(Integer.parseUnsignedInt(value));
                            }
                            catch (NumberFormatException e) {
                                Colorwheel.LOGGER.error("Invalid coefficient id: {}", (Object)value);
                                continue;
                            }
                        }
                        Utils.findFirst(this.gbuffersOitAccumulateOverrides, t -> t.drawBuffer() == drawBuffer).ifPresentOrElse(t -> t.setCoefficientId(coefficientId), () -> this.gbuffersOitAccumulateOverrides.add(new ClrwlOitAccumulateOverride(drawBuffer, coefficientId)));
                        continue;
                    }
                    if (path.length == 4 && path[3].equals("format")) {
                        try {
                            format = InternalTextureFormat.valueOf((String)value);
                            Utils.findFirst(this.gbuffersOitAccumulateOverrides, t -> t.drawBuffer() == drawBuffer).ifPresentOrElse(t -> t.setFormat(format), () -> this.gbuffersOitAccumulateOverrides.add(new ClrwlOitAccumulateOverride(drawBuffer, format)));
                        }
                        catch (IllegalArgumentException e) {
                            Colorwheel.LOGGER.error("Unknown format: {}", (Object)value);
                        }
                        continue;
                    }
                }
                Colorwheel.LOGGER.error("Unknown OIT key: {}", (Object)path[2]);
                continue;
            }
            if (path[1].equals("shadow")) {
                if (path.length == 2) {
                    this.shadowOitEnabled = value.trim().equalsIgnoreCase("true");
                    continue;
                }
                if (path[2].equals("coefficientRanks") && path.length == 3) {
                    this.parseCoefficientsRanks(value).ifPresent(ranks -> {
                        this.shadowOitCoeffRanks = ranks;
                    });
                    continue;
                }
                if (path[2].startsWith("shadowcolor")) {
                    int drawBuffer;
                    try {
                        drawBuffer = Integer.parseUnsignedInt(path[2].substring(11));
                    }
                    catch (NumberFormatException e) {
                        Colorwheel.LOGGER.error("Invalid attachment: {}", (Object)path[2]);
                        continue;
                    }
                    if (path.length == 3) {
                        if (value.equals("frontmost")) {
                            coefficientId = Optional.empty();
                        } else {
                            try {
                                coefficientId = Optional.of(Integer.parseUnsignedInt(value));
                            }
                            catch (NumberFormatException e) {
                                Colorwheel.LOGGER.error("Invalid coefficient id: {}", (Object)value);
                                continue;
                            }
                        }
                        Utils.findFirst(this.shadowOitAccumulateOverrides, t -> t.drawBuffer() == drawBuffer).ifPresentOrElse(t -> t.setCoefficientId(coefficientId), () -> this.shadowOitAccumulateOverrides.add(new ClrwlOitAccumulateOverride(drawBuffer, coefficientId)));
                        continue;
                    }
                    if (path.length == 4 && path[3].equals("format")) {
                        try {
                            format = InternalTextureFormat.valueOf((String)value);
                            Utils.findFirst(this.shadowOitAccumulateOverrides, t -> t.drawBuffer() == drawBuffer).ifPresentOrElse(t -> t.setFormat(format), () -> this.shadowOitAccumulateOverrides.add(new ClrwlOitAccumulateOverride(drawBuffer, format)));
                        }
                        catch (IllegalArgumentException e) {
                            Colorwheel.LOGGER.error("Unknown format: {}", (Object)value);
                        }
                        continue;
                    }
                }
                Colorwheel.LOGGER.error("Unknown OIT key: {}", (Object)path[2]);
                continue;
            }
            Colorwheel.LOGGER.error("Unknown program groug for OIT: {}", (Object)path[1]);
        }
    }

    private Optional<BlendMode> parseBlendMode(String value) {
        String[] modeStrs = value.split(" ");
        int[] modeFcts = new int[modeStrs.length];
        if (modeFcts.length != 4) {
            Colorwheel.LOGGER.error("Invalid blend function count: {} (expected 4)", (Object)modeFcts.length);
            return Optional.empty();
        }
        for (int i = 0; i < modeStrs.length; ++i) {
            Optional maybeFct = BlendModeFunction.fromString((String)modeStrs[i]);
            if (maybeFct.isEmpty()) {
                Colorwheel.LOGGER.error("Unknown blend function: {}", (Object)modeStrs[i]);
                continue;
            }
            modeFcts[i] = ((BlendModeFunction)maybeFct.get()).getGlId();
        }
        return Optional.of(new BlendMode(modeFcts[0], modeFcts[1], modeFcts[2], modeFcts[3]));
    }

    private Optional<int[]> parseCoefficientsRanks(String value) {
        String[] rankStrs = value.split(",");
        int[] ranks = new int[rankStrs.length];
        for (int i = 0; i < rankStrs.length; ++i) {
            int rank;
            String rankStr = rankStrs[i].trim();
            try {
                rank = Integer.parseUnsignedInt(rankStr);
            }
            catch (NumberFormatException e) {
                Colorwheel.LOGGER.error("Invalid OIT coefficients ranks: {}", (Object)value);
                return Optional.empty();
            }
            if (rank == 0 || rank > 3) {
                Colorwheel.LOGGER.error("Invalid OIT coefficients ranks: {} (must be >= 1 && <= 3)", (Object)value);
                return Optional.empty();
            }
            ranks[i] = rank;
        }
        return Optional.of(ranks);
    }

    public Optional<ClrwlBlendModeOverride> getBlendModeOverride(ClrwlProgramId programId) {
        return Optional.ofNullable(this.programBlendOverrides.get((Object)programId));
    }

    public List<BufferBlendInformation> getBufferBlendModeOverrides(ClrwlProgramId programId) {
        ArrayList<BufferBlendInformation> list = this.bufferBlendOverrides.get((Object)programId);
        if (list == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(list);
    }

    public boolean shouldRenderShadow() {
        return this.shadowEnabled;
    }

    public boolean isOitEnabled(ClrwlProgramGroup group) {
        switch (group) {
            case GBUFFERS: {
                return this.gbuffersOitEnabled;
            }
            case SHADOW: {
                return this.shadowOitEnabled;
            }
        }
        throw new RuntimeException("Unknown program group: " + String.valueOf((Object)group));
    }

    public int[] getOitCoeffRanks(ClrwlProgramGroup group) {
        switch (group) {
            case GBUFFERS: {
                return this.gbuffersOitCoeffRanks;
            }
            case SHADOW: {
                return this.shadowOitCoeffRanks;
            }
        }
        throw new RuntimeException("Unknown program group: " + String.valueOf((Object)group));
    }

    public List<ClrwlOitAccumulateOverride> getOitAccumulateOverrides(ClrwlProgramGroup group) {
        switch (group) {
            case GBUFFERS: {
                return this.gbuffersOitAccumulateOverrides;
            }
            case SHADOW: {
                return this.shadowOitAccumulateOverrides;
            }
        }
        throw new RuntimeException("Unknown program group: " + String.valueOf((Object)group));
    }
}

