/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.chunk.serialization;

import net.caffeinemc.mods.lithium.common.world.chunk.CompactingPackedIntegerArray;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.chunk.Palette;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={SimpleBitStorage.class})
public abstract class SimpleBitStorageMixin
implements CompactingPackedIntegerArray {
    @Shadow
    @Final
    private int size;
    @Shadow
    @Final
    private int bits;
    @Shadow
    @Final
    private long mask;
    @Shadow
    @Final
    private int valuesPerLong;
    @Shadow
    @Final
    private long[] data;

    @Override
    public <T> void lithium$compact(Palette<T> srcPalette, Palette<T> dstPalette, short[] out) {
        if (this.size >= Short.MAX_VALUE) {
            throw new IllegalStateException("Array too large");
        }
        if (this.size != out.length) {
            throw new IllegalStateException("Array size mismatch");
        }
        short[] mappings = new short[(int)(this.mask + 1L)];
        int idx = 0;
        long[] lArray = this.data;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long word;
            long bits = word = lArray[i];
            for (int elementIdx = 0; elementIdx < this.valuesPerLong; ++elementIdx) {
                int value = (int)(bits & this.mask);
                int remappedId = mappings[value];
                if (remappedId == 0) {
                    remappedId = dstPalette.idFor(srcPalette.valueFor(value)) + 1;
                    mappings[value] = (short)remappedId;
                }
                out[idx] = (short)(remappedId - 1);
                bits >>= this.bits;
                if (++idx < this.size) continue;
                return;
            }
        }
    }
}

