/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.items;

import com.github.talrey.createdeco.BlockRegistry;
import com.github.talrey.createdeco.blocks.CoinStackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CoinStackItem
extends Item {
    public final String material;

    public CoinStackItem(Item.Properties props) {
        this(props, "iron");
    }

    public CoinStackItem(Item.Properties props, String material) {
        super(props);
        this.material = material;
    }

    protected boolean placeBlock(UseOnContext ctx) {
        BlockPlaceContext bictx = new BlockPlaceContext(ctx);
        BlockState target = ctx.getLevel().getBlockState(ctx.getClickedPos());
        if (target.getBlock() instanceof CoinStackBlock && this.material.equals(((CoinStackBlock)target.getBlock()).material) && (Integer)target.getValue((Property)BlockStateProperties.LAYERS) < 8) {
            int height = (Integer)target.getValue((Property)BlockStateProperties.LAYERS);
            if (!ctx.getLevel().isClientSide()) {
                ctx.getLevel().setBlockAndUpdate(ctx.getClickedPos(), (BlockState)((BlockState)BlockRegistry.COIN_BLOCKS.get(this.material).getDefaultState().setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf(height + 1))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().isWaterAt(ctx.getClickedPos()) && height + 1 != 8)));
            }
            return true;
        }
        if (target.canBeReplaced(bictx)) {
            if (!CoinStackBlock.canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos())) {
                return false;
            }
            if (!ctx.getLevel().isClientSide()) {
                ctx.getLevel().setBlockAndUpdate(ctx.getClickedPos(), BlockRegistry.COIN_BLOCKS.get(this.material).getDefaultState());
            }
            return true;
        }
        BlockPos offset = ctx.getClickedPos().offset(ctx.getClickedFace().getNormal());
        target = ctx.getLevel().getBlockState(offset);
        if (target.canBeReplaced(bictx)) {
            if (!CoinStackBlock.canSurvive((LevelReader)ctx.getLevel(), offset)) {
                return false;
            }
            if (!ctx.getLevel().isClientSide()) {
                ctx.getLevel().setBlockAndUpdate(offset, BlockRegistry.COIN_BLOCKS.get(this.material).getDefaultState());
            }
            return true;
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (this.placeBlock(ctx)) {
            ctx.getItemInHand().shrink(1);
            ctx.getLevel().playSound(null, ctx.getClickedPos(), SoundEvents.CHAIN_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }
}

