/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.mixin.compat.owo;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursor;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursorTracker;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import io.wispforest.owo.ui.util.CursorAdapter;
import java.util.Collection;
import java.util.function.Consumer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={CursorAdapter.class}, remap=false)
public abstract class CursorAdapterMixin {
    @Unique
    private static final int minecraft_cursor$OWO = CursorAdapter.class.hashCode();

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwCreateStandardCursor(I)J")})
    private long trackStandardCursors(int shape, Operation<Long> original) {
        CursorType cursorType;
        long cursor = (Long)original.call(new Object[]{shape});
        if (cursor != 0L && (cursorType = CursorTypeUtil.mapGLFWCursor(shape)) != null) {
            ExternalCursorTracker.trackCursor(cursor, minecraft_cursor$OWO, cursorType);
        }
        return cursor;
    }

    @WrapOperation(method={"dispose"}, at={@At(value="INVOKE", target="Ljava/util/Collection;forEach(Ljava/util/function/Consumer;)V")})
    private void untrackStandardCursors(Collection<Long> instance, Consumer<Long> consumer, Operation<Void> original) {
        instance.forEach(ExternalCursorTracker.get()::untrackCursor);
        original.call(new Object[]{instance, consumer});
    }

    @WrapOperation(method={"applyStyle"}, at={@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwSetCursor(JJ)V")})
    private void updateCursor(long window, long cursor, Operation<Void> original) {
        boolean nullCursor = cursor == 0L;
        ExternalCursor trackedCursor = ExternalCursorTracker.get().getTrackedCursor(cursor);
        if (!MinecraftCursor.CONFIG.isRemapCursorsEnabled() || window != CursorTypeUtil.WINDOW || !nullCursor && trackedCursor == null) {
            original.call(new Object[]{window, cursor});
            return;
        }
        ExternalCursorTracker.get().updateCursor(minecraft_cursor$OWO, nullCursor ? CursorType.DEFAULT : trackedCursor.getCursorType());
    }
}

