/*
 * Decompiled with CFR 0.152.
 */
package com.samgj15.nightlights.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public abstract class AbstractLightBlock
extends Block {
    public static final IntegerProperty BRIGHTNESS = IntegerProperty.create((String)"brightness", (int)0, (int)15);
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");

    protected AbstractLightBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> (Boolean)state.getValue((Property)LIT) != false ? (Integer)state.getValue((Property)BRIGHTNESS) : 0));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if (this.isAdjustable()) {
                this.handleLightInteraction(state, level, pos);
            } else {
                this.handleFixedLightInteraction(state, level, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void handleLightInteraction(BlockState state, Level level, BlockPos pos) {
        boolean isLit = (Boolean)state.getValue((Property)LIT);
        int currentBrightness = (Integer)state.getValue((Property)BRIGHTNESS);
        int[] levels = this.getBrightnessLevels();
        if (!isLit || currentBrightness == 0) {
            BlockState newState = (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)BRIGHTNESS, (Comparable)Integer.valueOf(levels[1]));
            level.setBlock(pos, newState, 3);
            this.playLightSound(level, pos, true, levels[1]);
        } else {
            int nextIndex;
            int nextBrightness;
            int currentIndex = -1;
            for (int i = 0; i < levels.length; ++i) {
                if (levels[i] != currentBrightness) continue;
                currentIndex = i;
                break;
            }
            if ((nextBrightness = levels[nextIndex = (currentIndex + 1) % levels.length]) == 0) {
                BlockState newState = (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)BRIGHTNESS, (Comparable)Integer.valueOf(this.getDefaultBrightness()));
                level.setBlock(pos, newState, 3);
                this.playLightSound(level, pos, false, 0);
            } else {
                BlockState newState = (BlockState)state.setValue((Property)BRIGHTNESS, (Comparable)Integer.valueOf(nextBrightness));
                level.setBlock(pos, newState, 3);
                this.playLightSound(level, pos, true, nextBrightness);
            }
        }
    }

    protected void handleFixedLightInteraction(BlockState state, Level level, BlockPos pos) {
        boolean isLit = (Boolean)state.getValue((Property)LIT);
        if (isLit) {
            BlockState newState = (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, newState, 3);
            this.playLightSound(level, pos, false, 0);
        } else {
            BlockState newState = (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos, newState, 3);
            this.playLightSound(level, pos, true, this.getDefaultBrightness());
        }
    }

    protected void playLightSound(Level level, BlockPos pos, boolean turnOn, int brightness) {
        if (turnOn) {
            float pitch = 0.5f + (float)brightness * 0.03f;
            level.playSound(null, pos, SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, 0.6f, pitch);
        } else {
            level.playSound(null, pos, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundSource.BLOCKS, 0.6f, 0.5f);
        }
    }

    protected abstract int getDefaultBrightness();

    protected boolean isAdjustable() {
        return false;
    }

    protected int[] getBrightnessLevels() {
        return new int[]{0, this.getDefaultBrightness()};
    }
}

