/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.ash_api.options;

import com.diontryban.ash_api.AshApi;
import com.diontryban.ash_api.modloader.ModLoader;
import com.diontryban.ash_api.options.ModOptions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.AvailableSince(value="20.2.0-beta")
public final class ModOptionsManager<O extends ModOptions> {
    @NotNull
    private final String modId;
    @NotNull
    private final Class<O> optionsClass;
    @NotNull
    private final File file;
    @NotNull
    private O options;

    @ApiStatus.AvailableSince(value="20.2.0-beta")
    public ModOptionsManager(@NotNull String modId, @NotNull Class<O> optionsClass) {
        this.modId = modId;
        this.optionsClass = optionsClass;
        this.file = ModLoader.getConfigDir().resolve(modId + ".json").toFile();
        this.options = this.defaultOptions();
        this.read();
    }

    private O defaultOptions() {
        try {
            return (O)((ModOptions)this.optionsClass.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("Config for mod " + this.modId + " does not have an empty constructor.");
        }
    }

    @ApiStatus.AvailableSince(value="20.2.0-beta")
    public void read() {
        if (!this.file.exists()) {
            this.options = this.defaultOptions();
            this.write();
        } else {
            try (FileReader reader = new FileReader(this.file);){
                Gson gson = new Gson();
                this.options = (ModOptions)gson.fromJson((Reader)reader, this.optionsClass);
                if (this.options == null || ((ModOptions)this.options).version < ((ModOptions)this.defaultOptions()).version) {
                    AshApi.LOG.info("Found deprecated config file for mod {}. Updating.", (Object)this.modId);
                    this.options = this.defaultOptions();
                    this.write();
                }
            }
            catch (Exception e) {
                AshApi.LOG.error("Failed to read {}'s config file.", (Object)this.modId);
                this.options = this.defaultOptions();
                this.write();
            }
        }
    }

    @ApiStatus.AvailableSince(value="20.2.0-beta")
    public void write() {
        try (FileWriter writer = new FileWriter(this.file);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            writer.write(gson.toJson(this.options));
            writer.flush();
        }
        catch (Exception e) {
            AshApi.LOG.error("Failed to write to config file for mod {}.", (Object)this.modId);
        }
    }

    @ApiStatus.AvailableSince(value="20.2.0-beta")
    @NotNull
    public O get() {
        return this.options;
    }

    @ApiStatus.AvailableSince(value="20.2.0-beta")
    @NotNull
    public String getModId() {
        return this.modId;
    }
}

